SET @remPayAppFeeRecId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REMINDER_TO_PAY_THE_APPLICATION_FEES_RECIPIENT');
 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "select 
    T1.id AS ID,
	T1.id AS APPLICATION_ID,	
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T1.`code` as APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T6.primaryeEmailId AS ACADEMY_EMAIL,
    T6.websiteURL AS WEBSITE_URL,
    concat(T6.phoneCountryCode,'-',T6.phoneAreaCode,'-',T6.phoneNo) AS PHONE_NUMBER,
    ml.code as LANGUAGE_KEY,
    (Case
        when
            T8.logoUrl is null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        when
            T8.logoUrl is null
                and org.orgUrl is null
        then
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        else CONCAT(org.orgUrl, '/', T8.logoUrl)
    end) as LOGO_URL,
    (Case
        when
            T8.headerUrl is not null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        else NULL
    end) as HEADER_URL,
    (Case
        when
            T8.footerUrl is not null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL
    end) as FOOTER_URL,
    T8.id as ACADEMY_LOCATION_ID,
    T8.academyId as ACADEMY_ID
from
    application T1
        left outer join
    applicant_person T2 ON T1.applicantPersonId = T2.id
        LEFT OUTER JOIN
    application_program T4 ON T4.applicationId = T1.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T4.academyLocationId
    LEFT OUTER JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T8.id
        LEFT OUTER JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
          LEFT JOIN
    multi_language ml on T2.correspondence_language=ml.id       
 where T1.id in(namedParams)",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "applicationCode",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 9
        },       
		{
			"id": 11,
			"value": "primaryeEmailId",
			"resultKey": "ACADEMY_EMAIL",
			"displayCode": "",
			"displayOrder": 10
		},
		{
			"id": 12,
			"value": "websiteURL",
			"resultKey": "WEBSITE_URL",
			"displayCode": "",
			"displayOrder": 11
		},
		{
			"id": 13,
			"value": "phoneNo",
			"resultKey": "PHONE_NUMBER",
			"displayCode": "",
			"displayOrder": 12
		},
        {
            "id": 14,
            "value": "academyLocationId",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 12            
        },
        {
			"id": 16,
            "value": "id",
            "resultKey": "APPLICATION_ID",
            "displayCode": "",
            "displayOrder": 15
		}
    ]}' WHERE (`dataProviderId` = @remPayAppFeeRecId);